//*********************************************************************
//  FileContrast.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.27 (5E, p. 290)
//*********************************************************************

import java.io.*;
import java.util.*;

public class FileContrast
{
   //-----------------------------------------------------------------
   //  Contrasts two text files.
   //-----------------------------------------------------------------
   public static void main (String [] args)
   {
      try
      {
         BufferedReader in1 = new BufferedReader (
                              new FileReader (
                              new File (args[0])));

         BufferedReader in2 = new BufferedReader (
                              new FileReader (
                              new File (args[1])));

         String ln1 = in1.readLine();
         String ln2 = in2.readLine();

         int lc1 = 1;
         int lc2 = 1;

         // contrast all lines until one end of file

         while ((ln1 != null) && (ln2 != null))
         {
            if (! ln1.equals(ln2))
               System.out.println ("1(" + lc1 + "): " + ln1 + "\n" +
                                   "2(" + lc2 + "): " + ln2);
            ln1 = in1.readLine();
            ln2 = in2.readLine();
            lc1++;
            lc2++;
         }

         // print all lines of the remaining file (if any)

         if (ln1 == null)
            while (ln2 != null)
            {
               System.out.println ("2(" + lc2 + "): " + ln2);
               ln2 = in2.readLine();
               lc2++;
            }
         else
            while (ln1 != null)
            {
               System.out.println ("1(" + lc1 + "): " + ln1);
               ln1 = in1.readLine();
               lc1++;
            }
      }
      catch (Exception ex)
      {
         ex.printStackTrace (System.err);
         System.out.println ("Usage: java FileContrast file1 file2");
      }
   }
}
